//----------------------------------------------------------------------
//
//	DBlock.cpp
//
//	Written by Matthew D Moss
//	1996, Ground Cover Software
//
//	A class to encapsulate operations to a chunk of data, including
//	range replacement, insertion, and removal.  Multiple access will be
//	allowed but shielded.
//
//----------------------------------------------------------------------


#pragma once


#include <List.h>

class BLooper;
class DBlockRange;


enum { msg_DataChanged = 'DatU' };


//----------------------------------------------------------------------
class DBlock {

	class DBBuf {
	public:
					DBBuf ();
					DBBuf (const DBBuf& rhs);
					DBBuf (const char* data, long length);
		virtual		~DBBuf ();
		
		DBBuf&		operator = (const DBBuf& rhs);
		
		friend bool	operator == (const DBBuf& lhs, const DBBuf& rhs);
		
		const char*	data (void) const;
		long		size (void) const;
		
		void		insert (long offset, const char* data, long length);
		void		remove (long offset, long length);

	private:
		enum { default_extend_alloc = 1024L };
		
		char*		buf;
		long		used;
		long		alloc;
	};
	
public:
					DBlock ();
					DBlock (const DBlock& rhs);
					DBlock (const char* data, long size);
	virtual			~DBlock ();
	
	DBlock&			operator = (const DBlock& rhs);
	DBlockRange		operator () (long offset, long length);
	
	friend bool		operator == (const DBlock& lhs, const DBlock& rhs);
	
	virtual const char*		Data (long& size) const;
	
	void			Register (BLooper* editor);
	void			Unregister (BLooper* editor);
	
//protected:
	virtual void	replace (long offset, long length, const DBlock& rhs);

private:
friend class BredWindow;
	void			close_regd (void);

	void			update_regd (void);

	DBBuf			block;
	BList			regd;
	
	sem_id			mutex;
};


class DBlockRange : public DBlock {

					DBlockRange ();
public:
					DBlockRange (const DBlockRange& rhs);
					DBlockRange (DBlock& base, long offset, long length);

	DBlockRange&	operator = (const DBlockRange& rhs);
	DBlockRange&	operator = (const DBlock& rhs);

	virtual const char*		Data (long &size) const;
						
//protected:
	virtual void	replace (long offset, long length, const DBlock& rhs);

private:
	DBlock&			bas;
	long			off;
	long			len;
};
